//	ADC.cpp 
//	written by Dr. Sam Green, W0PCE 
//	for the Fully Automated DDS Sweep Generator Measurement System 
/*
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//  Driver for MAXIM DAC110 with calibration procedure 
//  
//	This program reads ADC and writes to screen at rate dependent on resolution  
//  With +/-Vref set by LM385-1.2s to +/-1.234V volts, range is from -2.468V to +2.468V 
//		for a resolution of about 300 uV when running at 13 bit resolution   
//		 
//  syntax ADC 12 CR for 12 bit
//  syntax ADC 13 CR for 13 bit default
//  syntax ADC 14 CR for 14 bit
//		  
//  With hardware set up for bipolar operation,
//  +/-Vref each set by LM385-1.2 to +/-1.234V volts, range is from -2.464V to +2.464V 
//		or a resolution of about 150uV when running at 14 bits 
//  Vref = 2.4485 for prototype with LM113 reference diodes
//  Vref = 2.464 for Mark 2 with LM85-1.2 reference diodes (much better)

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <windows.h>

int writereaddatabits (int writeword);
void gotoxy (int x, int y) ;
void cal (void) ;

int base	= 0x378,		// parallel port register addresses
	status	= base+1,
	control	= base+2,
	writeword1 = 0x8100,	// input 1 and divide clock by 4
	writeword2 = 0x8110,	// input 2 and divide clock by 4
	CONVbits   = 0x0600,	// default 13 bits and 50 Hz 
	CSactive   = 0xbf,		// active low so set D6 = 0 
	CSinactive = 0xff,		//					D6 = 1 
	ClockLow   = 0xdf,		// set D6 = 0 
	ClockHi    = 0xff,		// active low so set D6 = 0 
	DataBitLow = 0xef,		// set D6 = 0 
	DataBitHi  = 0xff;		// active low so set D6 = 0 

float Vref = 2.4640;  
	  
void main(int argc, char *argv[]) {
    int dummy   = 0xdeaf,tt=0, intreading, sign, overflow, cc; 
	float floatreading;
	double  duration;
	clock_t start, finish;

	system("CLS");
	gotoxy(1,1);puts("Usage:\tADC 12 \t12 bit resolution (plus sign)\n\tADC 13 \t13 bit resolution default\n\tADC 14 \t14 bit resolution but slow");
    if (argc>1) {cc = atoi(argv[1]);}; // optionlly change CONVbits 
	switch (cc){
		case 12:	CONVbits = 0x1200 ;	break;	
		case 13:	CONVbits = 0x0600 ;	break;	
		case 14:	CONVbits = 0x0c00 ;	break;			
		default: ;	}	

	cal ();

	while(1){			
		dummy = writereaddatabits (writeword1 | CONVbits);
		start = clock();
		while((tt=0x80&_inp(base+1)) != 0) {if (clock() - start > 220) break ;}  // 220 millisecond limit 
		finish = clock();
		duration = (double)(finish - start) / CLOCKS_PER_SEC;  // CLOCKS_PER_SEC = 1000 
		gotoxy(3,7);printf("Elapsed Time is %2.3f seconds\n", duration );
		sign = dummy & 0x8000 ;
		overflow = dummy & 0x4000 ;
		intreading = 0xffffffff & dummy ; 
		if (sign == 0) intreading &= 0x000003fff; else intreading |= 0xffffc000; 
		floatreading = float (intreading * Vref) / 0x3fff ; 
		gotoxy(3,9);printf("voltage = %1.3f\t", floatreading) ; if (sign != overflow <<1) puts("OVERFLOW"); else puts("        "); 
	}			
}

int writereaddatabits (int writeword) {  
	int i, temp, writebyte, mask=0x10000, databit, dataword=0;
	_outp(base, CSactive & DataBitLow);			// pull CS low by writing a 0 to D6
	for(i=0; i<16; i++) {           
		writebyte = CSactive & ClockLow & DataBitLow; 
		_outp(base, writebyte);					// write clock low
		mask >>= 1 ; temp = writeword & mask ;	// setup data to write to DIN - data comes out MSB first
		if (temp==0) temp = DataBitHi; else temp = DataBitLow; 
		_outp(base, writebyte |= ~temp);
		_outp(base, writebyte|= ~ClockLow);		// write clock high 
		databit = 0x40 & _inp(base + 1) ;		// read data bit 6 from DOUT 
		if (databit != 0) {dataword |= mask;}	// build dataword one bit at a time from MSB to LSB 
		}	
	_outp(base, CSinactive & DataBitLow);		// pull CS hi 
	return dataword; 
}

void cal (void) {								// calibration procedure
	int step1 = 0xc, step2 = 8, step3 = 4, dummy, tt; 
	
	dummy = writereaddatabits (writeword1 | CONVbits | step1);  
	while((tt=0x80&_inp(base+1)) != 0) ;	 
	dummy = writereaddatabits (writeword1 | CONVbits | step2);  
	while((tt=0x80&_inp(base+1)) != 0) ; 
	dummy = writereaddatabits (writeword1 | CONVbits | step3);  
	while((tt=0x80&_inp(base+1)) != 0) ;  
}

void gotoxy (int x, int y){
	HANDLE hdl;
	COORD coords;
	hdl = GetStdHandle(STD_OUTPUT_HANDLE);
	coords.X=x-1;
	coords.Y=y-1;
	SetConsoleCursorPosition(hdl,coords);
}


